-- Fichero FSQL_AUX.sql
-------------------------------------------------------------------------------------
-- ***** ***** ***** FUNCIONES AUXILIARES para el Servidor FSQL ***** ***** *****  --
-- Funciones que podran estar en el paquete FSQL_SEMANTIC, pero que se incluyen   --
-- en un paquete aparte para que dicho paquete no sea excesivamente grande,        --
-- lo cual, puede provocar errores de compilacin (sobretodo en Oracle 8).         --
-- Estas funciones son usadas desde el paquete FSQL_SEMANTIC excepto inserta_error --
-- que es usado tambin por FSQL_PKG.                                              --
-- El paquete FSQL_PKG incorpora el procedimiento "insertar_error" que llama al de --
-- este paquete "inserta_error" (sin la r). As, un programa Cliente FSQL puede    --
-- insertar errores en la tabla FSQL_ERRORS fcilmente.
-- Usa tablas FSQL_QUERY, FSQL_ERRORS y tablas de FIRST (FCL...)                   --
-------------------------------------------------------------------------------------
CREATE OR REPLACE PACKAGE FSQL_AUX AS

-- Para uso de los paquetes FSQL_PKG, FSQL_SEMANTIC:
PROCEDURE inserta_error (MsgError IN VARCHAR2);

FUNCTION resto_llamada_tipo3(column VARCHAR2,
                             LEN    INTEGER) RETURN VARCHAR2;
PROCEDURE fuzzy_column_en_sl(atrib   IN FSQL_QUERY.atributo%TYPE,
                             ind     IN FSQL_QUERY.indice%TYPE,
                             f_tipo  IN FUZZY_COL_LIST.F_TYPE%TYPE,
                             OBJ IN OUT FUZZY_COL_LIST.OBJ#%TYPE,
                             COL IN OUT FUZZY_COL_LIST.COL#%TYPE,
                             alias IN VARCHAR2);
FUNCTION calcula_umbral(ind FSQL_QUERY.indice%TYPE) RETURN VARCHAR2;
PROCEDURE Calcula_Margen_Much(OBJ    IN  FUZZY_APPROX_MUCH.OBJ#%TYPE,
                              COL    IN  FUZZY_APPROX_MUCH.COL#%TYPE,
                              pos    IN  FSQL_QUERY.posicion%TYPE,
                              st     IN  VARCHAR2,
                              nameC  IN  FSQL_QUERY.atributo%TYPE,
                              margen OUT FUZZY_APPROX_MUCH.MARGEN%TYPE,
                              much   OUT FUZZY_APPROX_MUCH.MUCH%TYPE);
FUNCTION Sin_N(fcomp IN  VARCHAR2) RETURN VARCHAR2;

END FSQL_AUX;
/

CREATE OR REPLACE PACKAGE BODY FSQL_AUX AS

----------------------------------------------------------------------
-- Inserta un msg de error en la tabla de errores: FSQL_ERRORS
-- La insercin ser realiza cronolgicamente ordenados por el campo INDICE (empezando por 1)
-- Se inserta el nmero de la sesin actual en el campo SESSIONID.
----------------------------------------------------------------------
PROCEDURE inserta_error (MsgError IN VARCHAR2) IS
  ultimo INTEGER;
BEGIN
  SELECT MAX(INDICE) INTO ultimo FROM FSQL_ERRORS;
  IF ultimo IS NULL THEN ultimo:=0; END IF;
  INSERT INTO FSQL_ERRORS VALUES (USERENV('SESSIONID'),ultimo+1, MsgError);
END inserta_error;

----------------------------------------------------------------------------------------------------------
-- Devuelve los ltimos 21 parmetros de la llamada a la funcin fshow3 con el ')' incluido,
-- para la columna column (de tipo 3), con long. mxima de LEN
----------------------------------------------------------------------------------------------------------
FUNCTION resto_llamada_tipo3(column VARCHAR2,
                             LEN    INTEGER) RETURN VARCHAR2
IS
  result VARCHAR2(350);
  i INTEGER;   -- Nmero de etiqueta que procesamos
BEGIN
  result:=column||'T,';
  FOR i IN 1..10 LOOP
    IF i<=LEN THEN
      IF    i=1 THEN result:=result     ||column||'P1,'||column||'1';
      ELSIF i=2 THEN result:=result||','||column||'P2,'||column||'2';
      ELSIF i=3 THEN result:=result||','||column||'P3,'||column||'3';
      ELSIF i=4 THEN result:=result||','||column||'P4,'||column||'4';
      ELSIF i=5 THEN result:=result||','||column||'P5,'||column||'5';
      ELSIF i=6 THEN result:=result||','||column||'P6,'||column||'6';
      ELSIF i=7 THEN result:=result||','||column||'P7,'||column||'7';
      ELSIF i=8 THEN result:=result||','||column||'P8,'||column||'8';
      ELSIF i=9 THEN result:=result||','||column||'P9,'||column||'9';
      ELSIF i=10 THEN result:=result||','||column||'P10,'||column||'10';
      END IF;
    ELSE
      result:=result||',NULL,NULL';
    END IF;
  END LOOP;
  RETURN result||')';
END resto_llamada_tipo3;

----------------------------------------------------------------------------------------------------------
-- Modifica el atributo de FSQL_QUERY de las columnas difusas tipo 2  3
-- de la select_list. En su lugar pone una llamada a la funcin correspondiente
-- para mostrar ese atributo difuso de forma coherente (funciones fshow2 y fshow3)
----------------------------------------------------------------------------------------------------------
PROCEDURE fuzzy_column_en_sl(atrib   IN FSQL_QUERY.atributo%TYPE,
                             ind     IN FSQL_QUERY.indice%TYPE,
                             f_tipo  IN FUZZY_COL_LIST.F_TYPE%TYPE,
                             OBJ IN OUT FUZZY_COL_LIST.OBJ#%TYPE,
                             COL IN OUT FUZZY_COL_LIST.COL#%TYPE,
                             alias IN VARCHAR2)
IS
  fshow3    VARCHAR2(750);           -- Para formar la llamada a la funcin fshow3
  L         FUZZY_COL_LIST.LEN%TYPE; -- Nmero mximo de etiquetas en un atributo tipo 3 (LEN)
BEGIN
  IF f_tipo=2 THEN
     UPDATE FSQL_QUERY SET nombre='ok',
       atributo='FSQL_FUNCTIONS.FSHOW2('||OBJ||','||COL||','||
       atrib||'T,'||atrib||'1,'||atrib||'2,'||atrib||'3,'||atrib||'4)'||alias
       WHERE indice=ind;
  ELSE -- f_tipo=3
     -- Primero hallamos la longitud de ese atributo (mximo nmero de etiquetas por tupla)
     -- para utilizar FSHOW o FSHOW_LEN1:
     SELECT LEN INTO L FROM FUZZY_COL_LIST WHERE OBJ#=OBJ AND COL#=COL;

     -- Hallamos la columna (OBJ,COL) con las etiquetas definidas en FUZZY_NEARNESS_DEF
     BEGIN SELECT OBJ#2,COL#2 INTO OBJ,COL FROM FUZZY_COMPATIBLE_COL
             WHERE OBJ#1=OBJ AND COL#1=COL;
     EXCEPTION WHEN NO_DATA_FOUND THEN NULL;
     END;

     IF L=1 THEN -- Simplifica la llamada a la funcin que representa los tipo 3
       UPDATE FSQL_QUERY SET nombre='ok',
         atributo='FSQL_FUNCTIONS.FSHOW3_LEN1('||OBJ||','||COL||','||
         atrib||'T,'||atrib||'P1,'||atrib||'1)'||alias
         WHERE indice=ind;
     ELSE
       fshow3:=resto_llamada_tipo3(atrib,L);
       -- Cambiamos la columna por la llamada a fshow3
       UPDATE FSQL_QUERY SET nombre='ok',
         atributo='FSQL_FUNCTIONS.FSHOW3('||OBJ||','||COL||','||L||','||fshow3||alias
         WHERE indice=ind;
     END IF;
  END IF;
END fuzzy_column_en_sl;

----------------------------------------------------------------------------------------------
-- Devuelve la cadena que indica el umbral de la consulta que se debe aadir tras
-- la llamada a la funcin de comparacin.
-- Usa el ndice en FSQL_QUERY donde debera empezar la clusula del umbral.
-- Modifica el atributo de FSQL_QUERY para que el umbral sea vlido.
----------------------------------------------------------------------------------------------
FUNCTION calcula_umbral(ind FSQL_QUERY.indice%TYPE) RETURN VARCHAR2
IS
  token FSQL_QUERY.nombre%TYPE;
BEGIN
  BEGIN
    SELECT nombre INTO token FROM FSQL_QUERY WHERE indice=ind;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN token:='sin umbral'; -- Columna al final de la consulta
  END;

  IF token='sin umbral' THEN
     RETURN '=1'; -- Si no hay umbral, el umbral es 1
  ELSIF token='THOLD' THEN -- Si encontramos la palabra reservada THOLD la sustituimos por >=
     UPDATE FSQL_QUERY SET atributo='>=' WHERE indice=ind;
     RETURN NULL;
  ELSIF token='NUMBRAL' THEN -- La palabra THOLD es opcional: Si se omite el efecto es el mismo
     UPDATE FSQL_QUERY SET atributo='>='||atributo WHERE indice=ind;
     RETURN NULL;
  ELSE -- Tenemos un comparador (Ej: c1 FEQ c2 <= .4): En ese caso lo dejamos tal cual
     RETURN NULL;
  END IF;
END calcula_umbral;

----------------------------------------------------------------------------------------------
-- Calcula el margen y el much para un atributo concreto (OBJ,COL).
-- Si no estn definidos estos valores en la tabla FUZZY_APPROX_MUCH:
-- inserta un error y los devuelve como NULL.
-- Estos valores se usan con los comparadores MGT, MLT, NMGT y NMLT.
----------------------------------------------------------------------------------------------
PROCEDURE Calcula_Margen_Much(OBJ    IN  FUZZY_APPROX_MUCH.OBJ#%TYPE,
                              COL    IN  FUZZY_APPROX_MUCH.COL#%TYPE,
                              pos    IN  FSQL_QUERY.posicion%TYPE,
                              st     IN  VARCHAR2,
                              nameC  IN  FSQL_QUERY.atributo%TYPE,
                              margen OUT FUZZY_APPROX_MUCH.MARGEN%TYPE,
                              much   OUT FUZZY_APPROX_MUCH.MUCH%TYPE) IS
BEGIN
  SELECT MARGEN,MUCH INTO margen,much FROM FUZZY_APPROX_MUCH
    WHERE OBJ#=OBJ AND COL#=COL;
EXCEPTION WHEN NO_DATA_FOUND THEN -- Error: No tiene definidos los valores
  inserta_error('ERROR en FIRST en posicin '||pos
    ||': Atributo '||st||'.'||nameC||', (OBJ#,COL#)=('||OBJ||','||COL
    ||') no tiene definido el MARGEN y el MUCH en la tabla FUZZY_APPROX_MUCH. '
    ||'Estos son necesarios para usar los comparadores MGT, MLT, NMGT y NMLT.');
  margen:=NULL; much:=NULL;
END Calcula_Margen_Much;

----------------------------------------------------------------------------------------------
-- Los comparadores 'NFEQ','NFGT','NFGEQ','NFLT' y 'NFLEQ' son iguales a
-- sus homnimos sin la 'N' (de posibilidad) cuando comparan con un crisp
-- (o atributos difusos tipo 1). En ese caso, se llama a la funcin de
-- Posibilidad, evitando tener programada la funcin de Necesidad.
-- Esta funcin quita la 'N' de esos comparadores difusos, devolviendo el
-- comparador sin la 'N'.
----------------------------------------------------------------------------------------------
FUNCTION Sin_N (fcomp IN  VARCHAR2) RETURN VARCHAR2 IS
  fcompSinN VARCHAR2(4);
BEGIN
  IF fcomp IN ('NFEQ','NFGT','NFGEQ','NFLT','NFLEQ') THEN
     -- Devuelvo el comparador sin la 'N'
     SELECT SUBSTR(fcomp,2) INTO fcompSinN FROM DUAL;
     RETURN fcompSinN;
  ELSE RETURN fcomp;
  END IF;   
END Sin_N;

END FSQL_AUX;
/
